﻿Imports System
Imports System.Configuration
Imports System.ServiceModel
Imports System.ServiceModel.PeerResolvers

Namespace Microsoft.ServiceModel.Samples

    Public Class Form1
        Implements IChat

        Private member As String
        Private instanceContext As InstanceContext
        Private participant As IChatChannel
        Private ostat As IOnlineStatus
        Private factory As DuplexChannelFactory(Of IChatChannel)

        Public Sub New()
            ' 此调用是 Windows 窗体设计器所必需的。
            InitializeComponent()
            ' 请在 InitializeComponent() 调用后添加初始化。
        End Sub
        Public Sub New(ByVal member As String)
            Me.member = member
            InitializeComponent()
        End Sub

        Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button1.Click
            If RichTextBox2.Text <> "" Then
                participant.Chat(member, RichTextBox2.Text)
                RichTextBox2.Text = ""
            End If
        End Sub

        Private Sub Connect_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Connect.Click

            If TextBox1.Text <> "" Then
                member = TextBox1.Text
            Else
                member = "DefaultName"
            End If
            RichTextBox2.Text = "Message"
            RichTextBox1.Text = member + " is ready"
            RichTextBox1.AppendText(Chr(10) + "Type chat messages after going Online")
            RichTextBox1.Visible = True
            RichTextBox2.Visible = True
            Button1.Visible = True
            Connect.Visible = False
            TextBox1.Visible = False

            ' 构造 InstanceContext 以处理回调接口上的消息。 
            ' 会创建一个 ChatApp 实例，将其传递给 InstanceContext。
            instanceContext = New InstanceContext(Me)

            ' 使用给定终结点配置创建参与者
            ' 每个参与者都会打开一个指向网格的双工通道
            ' 参与者是已打开指向网格的通道的聊天应用程序实例
            factory = New DuplexChannelFactory(Of IChatChannel)(instanceContext, "ChatEndpoint")
            participant = factory.CreateChannel()

            ' 检索与参与者相关联的 PeerNode 并注册联机/脱机事件
            ' PeerNode 表示网格中的节点。网格是已连接的节点的命名集合。
            ostat = participant.GetProperty(Of IOnlineStatus)()
            AddHandler ostat.Online, AddressOf Me.OnOnline
            AddHandler ostat.Offline, AddressOf Me.OnOffline

            Try

                participant.Open()

            Catch generatedExceptionName As CommunicationException

                MsgBox("Could not find resolver.If you are using a custom resolver, please ensure that the service is running before executing this sample.  Refer to the readme for more details.")
                Return

            End Try


            ' 向其他参与者宣布加入
            participant.Join(member)

            ' 循环到用户退出为止
            ' 离开网格
        End Sub

        Public Sub Chat(ByVal member As String, ByVal msg As String) Implements IChat.Chat

            RichTextBox1.AppendText(Chr(10) + "[" + member + "] " + msg)

        End Sub

        Public Sub Join(ByVal member As String) Implements IChat.Join
            RichTextBox1.AppendText(Chr(10) + "[" + member + " joined] ")

        End Sub

        Public Sub Leave1(ByVal member As String) Implements IChat.Leave
            RichTextBox1.AppendText(Chr(10) + "[" + member + " left] ")

        End Sub

        Public Sub OnOnline(ByVal sender As Object, ByVal e As EventArgs)
            RichTextBox1.AppendText(Chr(10) + "** Online")


        End Sub

        Public Sub OnOffline(ByVal sender As Object, ByVal e As EventArgs)
            RichTextBox1.AppendText(Chr(10) + "** Offline")


        End Sub

    End Class
End Namespace
